﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="EventReminders.aspx.cs" Inherits="EventReminders" MasterPageFile ="~/Registry.master" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href = "styles/StyleSheet.css" />
    
    
    
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <script type = "text/javascript">

        $(document).ready(function()
        {

            $('input[id*=ButtonSnooze]').attr('disabled', 'disabled');

            $('span.redLabel').css({ "color": "#ff0000", "font-size": "x-large" });

            //$('td.sideMenuColumn').css({ "background-color": "#FFFFFF", "width":"0" });
            $('td.sideMenuColumn').remove();

            $('.tableView select[id*=DropDownSnoozeDurations]').change(function()
            {

                if ($(this).find(":selected").val() == 0)
                {
                    $(this).closest('tr').find('input[id*=ButtonSnooze]').attr('disabled', 'disabled');

                }
                else
                {
                    $(this).closest('tr').find('input[id*=ButtonSnooze]').removeAttr('disabled');

                }

            });
        });
    
    </script>    
    <div class="breadcrumb">
        
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text= "Follow Up Event Reminders" />
             
    </div>
    
    <br />
        <asp:Label ID = "ReminderWarningLabel" runat = "server" CssClass = "redLabel" Text = "Reminder!"></asp:Label>
    <br />
    
    
        <asp:GridView ID = "GridViewReferralEventReminders" runat = "server" DataSourceID = "ObjectDataSourceEventReminders" AutoGenerateColumns = "false"
    AllowPaging="True" PageSize="20" DataKeyNames = "ReferralId, ContactId, ActivityId" OnRowCommand = "EventReminders_RowCommand" AllowSorting = "true" >
       <EmptyDataTemplate>
            No reminders exist for any referrals
       </EmptyDataTemplate> 
        
        <Columns>
        
            <asp:TemplateField HeaderText = "Referral Number" SortExpression = "ReferralId" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelRefID" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralId")), false) %>' ></asp:Label> 
                
                </ItemTemplate> 
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Patient Name" SortExpression = "PatientLastName">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientFullName")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Reason" SortExpression = "Reason">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReason" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Reason")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Due Date" SortExpression = "DueDate">
                    
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelDueDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NormalizedDueDate")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
                                             
            <asp:TemplateField HeaderText="Remind Me On" SortExpression = "ReminderDate">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReminderDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NormalizedReminderDate")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="" SortExpression = "FollowUpType" Visible = "false">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelFollowupType" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("FollowUpType")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
            <asp:TemplateField HeaderText="">
                        
                    <ItemTemplate>
                        &nbsp;
                        <asp:DropDownList ID = "DropDownSnoozeDurations" runat = "server" 
                        DataSourceID = "ObjectDataSourceSnoozeDurations" 
                        DataValueField="Key" DataTextField="Value" AppendDataBoundItems = "true">
                            <asp:ListItem Value = "0" Text = "(Select Period)"></asp:ListItem>
                        
                        </asp:DropDownList>
                        &nbsp;
                        <asp:Button ID = "ButtonSnooze" runat = "server" Text = "Snooze" CommandName = "Snooze" CommandArgument="<%# Container.DataItemIndex %>" />   
                        &nbsp;
                    </ItemTemplate>                            
            </asp:TemplateField> 
            
        </Columns>
                
    </asp:GridView>    
            
    <asp:ObjectDataSource ID="ObjectDataSourceEventReminders" runat="server" 
            SelectMethod="SelectEventReminderAll" 
            SelectCountMethod="SelectEventReminderAllCount" 
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True" 
            TypeName="VeteransAffairs.Registries.BusinessManager.FollowupManager"
            OnSelected = "EventReminders_Selected" >                 
   </asp:ObjectDataSource>
   <asp:ObjectDataSource ID="ObjectDataSourceSnoozeDurations" runat="server" 
            SelectMethod="GetBiomonitoringFollowupDurations" 
            TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
            
  </asp:ObjectDataSource>
   
</asp:Content>